VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CBASS_TIME"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'///////////////////////////////////////////////////////////////////
' CBASS_TIME.cls - Copyright (c) 2001-2002
'                            JOBnik! [Arthur Aminov, ISRAEL]
'                            e-mail: jobnik2k@hotmail.com
'
' This VB Class Module, shows how to Get:
'   - Total Playing Time, in Seconds, of any Stream/Music
'   - Playing Position in Seconds
'   - a Function that will Convert Total Seconds into:
'       Hours:Minutes:Seconds   =   01:25:50
'   - and much more... :)
'   * Some Functions are Based on Ian Lucks 'C' Examples!
'
'   * You may NOT use some of this functions, if you're using
'     latest BASS.DLL versions [I think since v1.3?]
'///////////////////////////////////////////////////////////////////

Dim ChanInfo As BASS_CHANNELINFO

'Convert total duration into time format: HH:MM:SS
Public Function GetTime(ByVal Seconds As Long) As String
    If Seconds <= 0 Then
        GetTime = "00:00:00"
        Exit Function
    End If
    
    Dim Hour As Single, min As Single, Sec As Single
    
    Hour = Seconds / 60 / 60
    Sec = Seconds Mod 60
    min = (Hour - Int(Hour)) * 60
  
    GetTime = Format(Int(Hour), "00") & ":" & Format(Int(min), "00") & ":" & Format(Int(Sec), "00")
End Function

'Get playing position in seconds of a Stream [NOT 4 MOD]
Public Function GetPlayingPos(ByVal handle As Long) As Integer
    On Error GoTo err_GetPlayingPos
        GetPlayingPos = BASS_ChannelBytes2Seconds(handle, BASS_ChannelGetPosition(handle))
    Exit Function
err_GetPlayingPos:
    GetPlayingPos = 0
End Function

'Get total Duration in Seconds of Stream/Music
Public Function GetDuration(ByVal handle As Long) As Long
    On Error GoTo err_GetDuration
    Dim Lens As Long
        Lens = BASS_StreamGetLength(handle) 'Stream Length
        If Lens = -1 Then Lens = BASS_MusicGetLength(handle, BASSTRUE)  'Music Length
    GetDuration = BASS_ChannelBytes2Seconds(handle, Lens)
    Exit Function
err_GetDuration:
    GetDuration = 0
End Function

'Returns - Bytes Per Second
Public Function GetBytesPerSecond(ByVal handle As Long) As Long
    On Error GoTo err_BPS
        Dim flags As Long, BPS As Long, channels As Integer
        Call BASS_ChannelGetAttributes(handle, BPS, 0, 0)  ' sample rate
        Call BASS_ChannelGetInfo(handle, ChanInfo) 'stereo/mono, 8/16 bit flags
        flags = ChanInfo.flags
        channels = ChanInfo.chans
        If channels > 2 Then channels = 2
        
        BPS = BPS * channels
        If Not (flags And BASS_SAMPLE_8BITS) Then BPS = BPS * 2
    GetBytesPerSecond = BPS
    Exit Function
err_BPS:
    GetBytesPerSecond = 0
End Function

'Returns - Kilo Bits Per Second
Public Function GetBitsPerSecond(ByVal handle As Long, FileLength As Long) As Long
    On Error GoTo err_KBPS
        GetBitsPerSecond = CInt(((FileLength * 8) / GetDuration(handle)) / 1000)
    Exit Function
err_KBPS:
    GetBitsPerSecond = 0
End Function

'Returns - 'Stereo'/'Mono'
Public Function GetMode(ByVal handle As Long) As String
    Call BASS_ChannelGetInfo(handle, ChanInfo)
    If ChanInfo.chans = 1 Then
        GetMode = "Mono"
    Else
        GetMode = "Stereo"
    End If
End Function

'Returns - 8/16 bits
Public Function GetBits(ByVal handle As Long) As Byte
    Call BASS_ChannelGetInfo(handle, ChanInfo)
    GetBits = IIf(ChanInfo.flags And BASS_SAMPLE_8BITS, 8, 16)
End Function

'Returns - Sample Rate [Frequency]
Public Function GetFrequency(ByVal handle As Long) As Long
    Call BASS_ChannelGetAttributes(handle, GetFrequency, 0, 0)
End Function

'Returns - DirectX version
Public Function GetDXver() As Byte
    Dim bi As BASS_INFO
    bi.size = LenB(bi)      'LenB(..) returns a byte data
    Call BASS_GetInfo(bi)
    GetDXver = bi.dsver
End Function
